/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.ftb.data.UserManager;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.util.ErrorUtils;
import net.ftb.util.SwingUtils;

public class ProfileAdderDialog
extends JDialog {
    private String updatecreds = "";
    private JLabel usernameLbl;
    private JTextField username;
    private JLabel passwordLbl;
    private JPasswordField password;
    private JLabel nameLbl;
    private JTextField name;
    private JCheckBox savePassword;
    private JCheckBox saveMojangData;
    private JButton add;
    private JLabel messageLbl;

    public ProfileAdderDialog(LaunchFrame instance, String unlocalizedMessage, boolean modal) {
        super((Frame)instance, modal);
        this.setUnlocalizedMessage(unlocalizedMessage);
        this.preSetup();
    }

    public ProfileAdderDialog(LaunchFrame instance, boolean modal) {
        super((Frame)instance, modal);
        this.preSetup();
    }

    public void preSetup() {
        this.setupGui();
        this.getRootPane().setDefaultButton(this.add);
        this.savePassword.setSelected(true);
        this.saveMojangData.setSelected(true);
        this.username.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                ProfileAdderDialog.this.name.setText(ProfileAdderDialog.this.username.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                ProfileAdderDialog.this.name.setText(ProfileAdderDialog.this.username.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.savePassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProfileAdderDialog.this.password.setEnabled(ProfileAdderDialog.this.savePassword.isSelected());
            }
        });
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ProfileAdderDialog.this.savePassword.isSelected()) {
                    if (ProfileAdderDialog.this.validate(ProfileAdderDialog.this.name.getText(), ProfileAdderDialog.this.username.getText(), ProfileAdderDialog.this.password.getPassword())) {
                        UserManager.addUser(ProfileAdderDialog.this.username.getText(), new String(ProfileAdderDialog.this.password.getPassword()), ProfileAdderDialog.this.name.getText());
                        UserManager.setSaveMojangData(ProfileAdderDialog.this.username.getText(), ProfileAdderDialog.this.saveMojangData.isSelected());
                        LaunchFrame.writeUsers(ProfileAdderDialog.this.name.getText());
                        ProfileAdderDialog.this.setVisible(false);
                    } else {
                        ErrorUtils.tossError(I18N.getLocaleString("PROFILADDER_ERROR"));
                    }
                } else if (ProfileAdderDialog.this.validate(ProfileAdderDialog.this.name.getText(), ProfileAdderDialog.this.username.getText())) {
                    UserManager.addUser(ProfileAdderDialog.this.username.getText(), "", ProfileAdderDialog.this.name.getText());
                    UserManager.setSaveMojangData(ProfileAdderDialog.this.username.getText(), ProfileAdderDialog.this.saveMojangData.isSelected());
                    LaunchFrame.writeUsers(ProfileAdderDialog.this.name.getText());
                    ProfileAdderDialog.this.setVisible(false);
                } else {
                    ErrorUtils.tossError(I18N.getLocaleString("PROFILADDER_ERROR"));
                }
            }
        });
    }

    public void setUnlocalizedMessage(String editingName) {
        if (editingName.equals("CHANGEDUUID")) {
            this.updatecreds = I18N.getLocaleString(editingName);
            this.password.setEnabled(false);
            this.savePassword.setSelected(false);
        } else if (editingName.equals("OLDCREDS")) {
            this.updatecreds = I18N.getLocaleString(editingName);
            this.password.setEnabled(false);
            this.savePassword.setSelected(false);
        }
    }

    private boolean validate(String name, String user, char[] pass) {
        return !name.isEmpty() && !user.isEmpty() && pass.length > 1 && !UserManager.getNames().contains(name) && !UserManager.getUsernames().contains(user);
    }

    private boolean validate(String name, String user) {
        return !name.isEmpty() && !user.isEmpty() && !UserManager.getNames().contains(name) && !UserManager.getUsernames().contains(user);
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("PROFILEADDER_TITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.usernameLbl = new JLabel(I18N.getLocaleString("PROFILEADDER_USERNAME"));
        this.username = new JTextField(16);
        this.passwordLbl = new JLabel(I18N.getLocaleString("PROFILEADDER_PASSWORD"));
        this.password = new JPasswordField(16);
        this.nameLbl = new JLabel(I18N.getLocaleString("PROFILEADDER_NAME"));
        this.name = new JTextField(16);
        this.savePassword = new JCheckBox(I18N.getLocaleString("PROFILEADDER_SAVEPASSWORD"));
        this.saveMojangData = new JCheckBox(I18N.getLocaleString("PROFILEADDER_SAVEMOJANGDATA"));
        this.add = new JButton(I18N.getLocaleString("MAIN_ADD"));
        this.usernameLbl.setLabelFor(this.username);
        this.passwordLbl.setLabelFor(this.password);
        this.nameLbl.setLabelFor(this.name);
        if (!this.updatecreds.equals("")) {
            this.messageLbl = new JLabel(this.updatecreds);
            panel.add(this.messageLbl);
        }
        panel.add(this.usernameLbl);
        panel.add(this.username);
        panel.add(this.passwordLbl);
        panel.add(this.password);
        panel.add(this.nameLbl);
        panel.add(this.name);
        panel.add(this.savePassword);
        panel.add(this.saveMojangData);
        panel.add(this.add);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.usernameLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.passwordLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.nameLbl, hSpring, "West", (Component)panel);
        Spring columnWidth = Spring.width(this.usernameLbl);
        if (!this.updatecreds.equals("")) {
            layout.putConstraint("West", (Component)this.messageLbl, hSpring, "West", (Component)panel);
            columnWidth = Spring.max(columnWidth, Spring.width(this.messageLbl));
        }
        columnWidth = SwingUtils.springMax(columnWidth, Spring.width(this.passwordLbl), Spring.width(this.nameLbl));
        hSpring = SwingUtils.springSum(hSpring, columnWidth, Spring.constant(10));
        layout.putConstraint("West", (Component)this.username, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.password, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.name, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.savePassword, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.saveMojangData, hSpring, "West", (Component)panel);
        columnWidth = SwingUtils.springMax(Spring.width(this.username), Spring.width(this.password), Spring.width(this.name), Spring.width(this.savePassword), Spring.width(this.saveMojangData));
        hSpring = SwingUtils.springSum(hSpring, columnWidth, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("HorizontalCenter", (Component)this.add, 0, "HorizontalCenter", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("Baseline", (Component)this.usernameLbl, 0, "Baseline", (Component)this.username);
        layout.putConstraint("North", (Component)this.username, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.max(Spring.height(this.usernameLbl), Spring.height(this.username));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("Baseline", (Component)this.passwordLbl, 0, "Baseline", (Component)this.password);
        layout.putConstraint("North", (Component)this.password, vSpring, "North", (Component)panel);
        rowHeight = Spring.height(this.passwordLbl);
        rowHeight = Spring.max(rowHeight, Spring.height(this.password));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("Baseline", (Component)this.nameLbl, 0, "Baseline", (Component)this.name);
        layout.putConstraint("North", (Component)this.name, vSpring, "North", (Component)panel);
        rowHeight = Spring.max(Spring.height(this.nameLbl), Spring.height(this.name));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("North", (Component)this.savePassword, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.savePassword), Spring.constant(10));
        layout.putConstraint("North", (Component)this.saveMojangData, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.saveMojangData), Spring.constant(10));
        layout.putConstraint("North", (Component)this.add, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.add), Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

